/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.dsl;

import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.integration.dsl.ComponentsRegistration;
import org.springframework.integration.kafka.dsl.KafkaProducerMessageHandlerSpec;
import org.springframework.integration.kafka.dsl.KafkaTemplateSpec;
import org.springframework.integration.kafka.outbound.KafkaProducerMessageHandler;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.listener.GenericMessageListenerContainer;
import org.springframework.kafka.requestreply.ReplyingKafkaTemplate;
import org.springframework.kafka.support.converter.RecordMessageConverter;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;

public class KafkaOutboundGatewaySpec<K, V, R, S extends KafkaOutboundGatewaySpec<K, V, R, S>>
extends KafkaProducerMessageHandlerSpec<K, V, S> {
    KafkaOutboundGatewaySpec(ReplyingKafkaTemplate<K, V, R> kafkaTemplate) {
        super(kafkaTemplate);
    }

    public S replyMessageConverter(RecordMessageConverter messageConverter) {
        ((KafkaProducerMessageHandler)((Object)this.target)).setReplyMessageConverter(messageConverter);
        return (S)((Object)((KafkaOutboundGatewaySpec)this._this()));
    }

    public S assigmentDuration(Duration duration) {
        ((KafkaProducerMessageHandler)((Object)this.target)).setAssignmentDuration(duration);
        return (S)((Object)((KafkaOutboundGatewaySpec)this._this()));
    }

    public static class ReplyingKafkaTemplateSpec<K, V, R>
    extends KafkaTemplateSpec<K, V> {
        ReplyingKafkaTemplateSpec(ReplyingKafkaTemplate<K, V, R> kafkaTemplate) {
            super(kafkaTemplate);
        }

        public ReplyingKafkaTemplateSpec<K, V, R> taskScheduler(TaskScheduler scheduler) {
            ((ReplyingKafkaTemplate)this.target).setTaskScheduler(scheduler);
            return this;
        }

        public ReplyingKafkaTemplateSpec<K, V, R> defaultReplyTimeout(Duration replyTimeout) {
            ((ReplyingKafkaTemplate)this.target).setDefaultReplyTimeout(replyTimeout);
            return this;
        }
    }

    public static class KafkaGatewayMessageHandlerTemplateSpec<K, V, R>
    extends KafkaOutboundGatewaySpec<K, V, R, KafkaGatewayMessageHandlerTemplateSpec<K, V, R>>
    implements ComponentsRegistration {
        private final ReplyingKafkaTemplateSpec<K, V, R> kafkaTemplateSpec;

        KafkaGatewayMessageHandlerTemplateSpec(ProducerFactory<K, V> producerFactory, GenericMessageListenerContainer<K, R> replyContainer) {
            super(new ReplyingKafkaTemplate(producerFactory, replyContainer));
            this.kafkaTemplateSpec = new ReplyingKafkaTemplateSpec((ReplyingKafkaTemplate)((KafkaProducerMessageHandler)((Object)this.target)).getKafkaTemplate());
        }

        public KafkaGatewayMessageHandlerTemplateSpec<K, V, R> configureKafkaTemplate(Consumer<ReplyingKafkaTemplateSpec<K, V, R>> configurer) {
            Assert.notNull(configurer, (String)"The 'configurer' cannot be null");
            configurer.accept(this.kafkaTemplateSpec);
            return (KafkaGatewayMessageHandlerTemplateSpec)this._this();
        }

        public Map<Object, String> getComponentsToRegister() {
            return Collections.singletonMap(this.kafkaTemplateSpec.getTemplate(), this.kafkaTemplateSpec.getId());
        }
    }
}

