/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.gateway;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.integration.gateway.GatewayProxyFactoryBean;
import org.springframework.integration.gateway.RequestReplyExchanger;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.support.management.ManageableLifecycle;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;

public class GatewayMessageHandler
extends AbstractReplyProducingMessageHandler
implements ManageableLifecycle {
    private final GatewayProxyFactoryBean<?> gatewayProxyFactoryBean;
    private volatile RequestReplyExchanger exchanger;
    private volatile boolean running;
    private final Lock lock = new ReentrantLock();

    public GatewayMessageHandler() {
        this.gatewayProxyFactoryBean = new GatewayProxyFactoryBean();
    }

    public void setRequestChannel(MessageChannel requestChannel) {
        this.gatewayProxyFactoryBean.setDefaultRequestChannel(requestChannel);
    }

    public void setRequestChannelName(String requestChannel) {
        this.gatewayProxyFactoryBean.setDefaultRequestChannelName(requestChannel);
    }

    public void setReplyChannel(MessageChannel replyChannel) {
        this.gatewayProxyFactoryBean.setDefaultReplyChannel(replyChannel);
    }

    public void setReplyChannelName(String replyChannel) {
        this.gatewayProxyFactoryBean.setDefaultReplyChannelName(replyChannel);
    }

    public void setErrorChannel(MessageChannel errorChannel) {
        this.gatewayProxyFactoryBean.setErrorChannel(errorChannel);
    }

    public void setErrorChannelName(String errorChannel) {
        this.gatewayProxyFactoryBean.setErrorChannelName(errorChannel);
    }

    public void setRequestTimeout(Long requestTimeout) {
        this.gatewayProxyFactoryBean.setDefaultRequestTimeout(requestTimeout);
    }

    public void setReplyTimeout(Long replyTimeout) {
        this.gatewayProxyFactoryBean.setDefaultReplyTimeout(replyTimeout);
    }

    public void setErrorOnTimeout(boolean errorOnTimeout) {
        this.gatewayProxyFactoryBean.setErrorOnTimeout(errorOnTimeout);
    }

    @Override
    protected Object handleRequestMessage(Message<?> requestMessage) {
        if (this.exchanger == null) {
            this.lock.lock();
            try {
                if (this.exchanger == null) {
                    this.initialize();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.exchanger.exchange(requestMessage);
    }

    private void initialize() {
        BeanFactory beanFactory = this.getBeanFactory();
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            ((ConfigurableListableBeanFactory)beanFactory).initializeBean(this.gatewayProxyFactoryBean, this.getComponentName() + "#gpfb");
        }
        try {
            this.exchanger = (RequestReplyExchanger)this.gatewayProxyFactoryBean.getObject();
        }
        catch (Exception e) {
            throw new BeanCreationException("Can't instantiate the GatewayProxyFactoryBean: " + String.valueOf(this), (Throwable)e);
        }
        if (this.running) {
            this.gatewayProxyFactoryBean.stop();
            this.gatewayProxyFactoryBean.start();
        }
    }

    @Override
    public void start() {
        this.gatewayProxyFactoryBean.start();
        this.running = true;
    }

    @Override
    public void stop() {
        this.gatewayProxyFactoryBean.stop();
        this.running = false;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }
}

