/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.context;

import java.util.Arrays;
import java.util.Properties;
import org.springframework.integration.JavaUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class IntegrationProperties {
    public static final IntegrationProperties DEFAULT_INSTANCE = new IntegrationProperties();
    public static final String INTEGRATION_PROPERTIES_PREFIX = "spring.integration.";
    public static final String CHANNELS_AUTOCREATE = "spring.integration.channels.autoCreate";
    public static final String CHANNELS_MAX_UNICAST_SUBSCRIBERS = "spring.integration.channels.maxUnicastSubscribers";
    public static final String CHANNELS_MAX_BROADCAST_SUBSCRIBERS = "spring.integration.channels.maxBroadcastSubscribers";
    public static final String ERROR_CHANNEL_REQUIRE_SUBSCRIBERS = "spring.integration.channels.error.requireSubscribers";
    public static final String ERROR_CHANNEL_IGNORE_FAILURES = "spring.integration.channels.error.ignoreFailures";
    public static final String TASK_SCHEDULER_POOL_SIZE = "spring.integration.taskScheduler.poolSize";
    public static final String THROW_EXCEPTION_ON_LATE_REPLY = "spring.integration.messagingTemplate.throwExceptionOnLateReply";
    public static final String READ_ONLY_HEADERS = "spring.integration.readOnly.headers";
    public static final String ENDPOINTS_NO_AUTO_STARTUP = "spring.integration.endpoints.noAutoStartup";
    public static final String ENDPOINTS_DEFAULT_TIMEOUT = "spring.integration.endpoints.defaultTimeout";
    private static final Properties DEFAULTS = new IntegrationProperties().toProperties();
    private boolean channelsAutoCreate = true;
    private int channelsMaxUnicastSubscribers = Integer.MAX_VALUE;
    private int channelsMaxBroadcastSubscribers = Integer.MAX_VALUE;
    private boolean errorChannelRequireSubscribers = true;
    private boolean errorChannelIgnoreFailures = true;
    private int taskSchedulerPoolSize = 10;
    private boolean messagingTemplateThrowExceptionOnLateReply = false;
    private String[] readOnlyHeaders = new String[0];
    private String[] noAutoStartupEndpoints = new String[0];
    private long endpointsDefaultTimeout = 30000L;
    private volatile Properties properties;

    public void setChannelsAutoCreate(boolean channelsAutoCreate) {
        this.channelsAutoCreate = channelsAutoCreate;
        this.properties = null;
    }

    public boolean isChannelsAutoCreate() {
        return this.channelsAutoCreate;
    }

    public void setChannelsMaxUnicastSubscribers(int channelsMaxUnicastSubscribers) {
        this.channelsMaxUnicastSubscribers = channelsMaxUnicastSubscribers;
        this.properties = null;
    }

    public int getChannelsMaxUnicastSubscribers() {
        return this.channelsMaxUnicastSubscribers;
    }

    public void setChannelsMaxBroadcastSubscribers(int channelsMaxBroadcastSubscribers) {
        this.channelsMaxBroadcastSubscribers = channelsMaxBroadcastSubscribers;
        this.properties = null;
    }

    public int getChannelsMaxBroadcastSubscribers() {
        return this.channelsMaxBroadcastSubscribers;
    }

    public void setErrorChannelRequireSubscribers(boolean errorChannelRequireSubscribers) {
        this.errorChannelRequireSubscribers = errorChannelRequireSubscribers;
        this.properties = null;
    }

    public boolean isErrorChannelRequireSubscribers() {
        return this.errorChannelRequireSubscribers;
    }

    public void setErrorChannelIgnoreFailures(boolean errorChannelIgnoreFailures) {
        this.errorChannelIgnoreFailures = errorChannelIgnoreFailures;
        this.properties = null;
    }

    public boolean isErrorChannelIgnoreFailures() {
        return this.errorChannelIgnoreFailures;
    }

    public void setTaskSchedulerPoolSize(int taskSchedulerPoolSize) {
        this.taskSchedulerPoolSize = taskSchedulerPoolSize;
        this.properties = null;
    }

    public int getTaskSchedulerPoolSize() {
        return this.taskSchedulerPoolSize;
    }

    public void setMessagingTemplateThrowExceptionOnLateReply(boolean messagingTemplateThrowExceptionOnLateReply) {
        this.messagingTemplateThrowExceptionOnLateReply = messagingTemplateThrowExceptionOnLateReply;
        this.properties = null;
    }

    public boolean isMessagingTemplateThrowExceptionOnLateReply() {
        return this.messagingTemplateThrowExceptionOnLateReply;
    }

    public void setReadOnlyHeaders(String ... readOnlyHeaders) {
        Assert.notNull((Object)readOnlyHeaders, (String)"'readOnlyHeaders' must not be null.");
        this.readOnlyHeaders = Arrays.copyOf(readOnlyHeaders, readOnlyHeaders.length);
        this.properties = null;
    }

    public String[] getReadOnlyHeaders() {
        return Arrays.copyOf(this.readOnlyHeaders, this.readOnlyHeaders.length);
    }

    public void setNoAutoStartupEndpoints(String ... noAutoStartupEndpoints) {
        Assert.notNull((Object)noAutoStartupEndpoints, (String)"'noAutoStartupEndpoints' must not be null.");
        this.noAutoStartupEndpoints = Arrays.copyOf(noAutoStartupEndpoints, noAutoStartupEndpoints.length);
        this.properties = null;
    }

    public String[] getNoAutoStartupEndpoints() {
        return Arrays.copyOf(this.noAutoStartupEndpoints, this.noAutoStartupEndpoints.length);
    }

    public long getEndpointsDefaultTimeout() {
        return this.endpointsDefaultTimeout;
    }

    public void setEndpointsDefaultTimeout(long endpointsDefaultTimeout) {
        this.endpointsDefaultTimeout = endpointsDefaultTimeout;
    }

    public Properties toProperties() {
        if (this.properties == null) {
            Properties props = new Properties();
            props.setProperty(CHANNELS_AUTOCREATE, "" + this.channelsAutoCreate);
            props.setProperty(CHANNELS_MAX_UNICAST_SUBSCRIBERS, "" + this.channelsMaxUnicastSubscribers);
            props.setProperty(CHANNELS_MAX_BROADCAST_SUBSCRIBERS, "" + this.channelsMaxBroadcastSubscribers);
            props.setProperty(ERROR_CHANNEL_REQUIRE_SUBSCRIBERS, "" + this.errorChannelRequireSubscribers);
            props.setProperty(ERROR_CHANNEL_IGNORE_FAILURES, "" + this.errorChannelIgnoreFailures);
            props.setProperty(TASK_SCHEDULER_POOL_SIZE, "" + this.taskSchedulerPoolSize);
            props.setProperty(THROW_EXCEPTION_ON_LATE_REPLY, "" + this.messagingTemplateThrowExceptionOnLateReply);
            props.setProperty(READ_ONLY_HEADERS, StringUtils.arrayToCommaDelimitedString((Object[])this.readOnlyHeaders));
            props.setProperty(ENDPOINTS_NO_AUTO_STARTUP, StringUtils.arrayToCommaDelimitedString((Object[])this.noAutoStartupEndpoints));
            props.setProperty(ENDPOINTS_DEFAULT_TIMEOUT, "" + this.endpointsDefaultTimeout);
            this.properties = props;
        }
        return this.properties;
    }

    public static IntegrationProperties parse(Properties properties) {
        IntegrationProperties integrationProperties = new IntegrationProperties();
        JavaUtils.INSTANCE.acceptIfHasText(properties.getProperty(CHANNELS_AUTOCREATE), value -> integrationProperties.setChannelsAutoCreate(Boolean.parseBoolean(value))).acceptIfHasText(properties.getProperty(CHANNELS_MAX_UNICAST_SUBSCRIBERS), value -> integrationProperties.setChannelsMaxUnicastSubscribers(Integer.parseInt(value))).acceptIfHasText(properties.getProperty(CHANNELS_MAX_BROADCAST_SUBSCRIBERS), value -> integrationProperties.setChannelsMaxBroadcastSubscribers(Integer.parseInt(value))).acceptIfHasText(properties.getProperty(ERROR_CHANNEL_REQUIRE_SUBSCRIBERS), value -> integrationProperties.setErrorChannelRequireSubscribers(Boolean.parseBoolean(value))).acceptIfHasText(properties.getProperty(ERROR_CHANNEL_IGNORE_FAILURES), value -> integrationProperties.setErrorChannelIgnoreFailures(Boolean.parseBoolean(value))).acceptIfHasText(properties.getProperty(TASK_SCHEDULER_POOL_SIZE), value -> integrationProperties.setTaskSchedulerPoolSize(Integer.parseInt(value))).acceptIfHasText(properties.getProperty(THROW_EXCEPTION_ON_LATE_REPLY), value -> integrationProperties.setMessagingTemplateThrowExceptionOnLateReply(Boolean.parseBoolean(value))).acceptIfHasText(properties.getProperty(READ_ONLY_HEADERS), value -> integrationProperties.setReadOnlyHeaders(StringUtils.commaDelimitedListToStringArray((String)value))).acceptIfHasText(properties.getProperty(ENDPOINTS_NO_AUTO_STARTUP), value -> integrationProperties.setNoAutoStartupEndpoints(StringUtils.commaDelimitedListToStringArray((String)value))).acceptIfHasText(properties.getProperty(ENDPOINTS_DEFAULT_TIMEOUT), value -> integrationProperties.setEndpointsDefaultTimeout(Long.parseLong(value)));
        return integrationProperties;
    }

    public static Properties defaults() {
        return DEFAULTS;
    }

    public static String getExpressionFor(String key) {
        if (DEFAULTS.containsKey(key)) {
            return "#{T(org.springframework.integration.context.IntegrationContextUtils).getIntegrationProperties(beanFactory).toProperties().getProperty('" + key + "')}";
        }
        throw new IllegalArgumentException("The provided key [" + key + "] isn't the one of Integration properties: " + String.valueOf(DEFAULTS.keySet()));
    }
}

