/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support;

import org.springframework.util.backoff.ExponentialBackOff;

public class ExponentialBackOffWithMaxRetries
extends ExponentialBackOff {
    private final int maxRetries;

    public ExponentialBackOffWithMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        this.calculateMaxElapsed();
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setInitialInterval(long initialInterval) {
        super.setInitialInterval(initialInterval);
        this.calculateMaxElapsed();
    }

    public void setMultiplier(double multiplier) {
        super.setMultiplier(multiplier);
        this.calculateMaxElapsed();
    }

    public void setMaxInterval(long maxInterval) {
        super.setMaxInterval(maxInterval);
        this.calculateMaxElapsed();
    }

    public void setMaxElapsedTime(long maxElapsedTime) {
        throw new IllegalStateException("'maxElapsedTime' is calculated from the 'maxRetries' property");
    }

    private void calculateMaxElapsed() {
        long maxElapsed;
        long maxInterval = this.getMaxInterval();
        long current = maxElapsed = Math.min(this.getInitialInterval(), maxInterval);
        for (int i = 1; i < this.maxRetries; ++i) {
            long next;
            current = next = Math.min((long)((double)current * this.getMultiplier()), maxInterval);
            maxElapsed += current;
        }
        super.setMaxElapsedTime(maxElapsed);
    }
}

