/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.Lifecycle;
import org.springframework.core.log.LogAccessor;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.util.Assert;

public class ContainerGroup
implements Lifecycle {
    private static final LogAccessor LOGGER = new LogAccessor(LogFactory.getLog(ContainerGroup.class));
    private final String name;
    private final Collection<MessageListenerContainer> containers = new LinkedHashSet<MessageListenerContainer>();
    private boolean running;

    public ContainerGroup(String name) {
        this.name = name;
    }

    public ContainerGroup(String name, List<MessageListenerContainer> containers) {
        this.name = name;
        this.containers.addAll(containers);
    }

    public ContainerGroup(String name, MessageListenerContainer ... containers) {
        this.name = name;
        for (MessageListenerContainer container : containers) {
            this.containers.add(container);
        }
    }

    public String getName() {
        return this.name;
    }

    public Collection<String> getListenerIds() {
        return this.containers.stream().map(container -> container.getListenerId()).map(id -> {
            Assert.state((id != null ? 1 : 0) != 0, (String)"Containers must have listener ids to be used here");
            return id;
        }).collect(Collectors.toList());
    }

    public boolean contains(MessageListenerContainer container) {
        return this.containers.contains(container);
    }

    public boolean allStopped() {
        return this.containers.stream().allMatch(container -> !container.isRunning());
    }

    public void addContainers(MessageListenerContainer ... theContainers) {
        for (MessageListenerContainer container : theContainers) {
            this.containers.add(container);
        }
    }

    public boolean removeContainer(MessageListenerContainer container) {
        return this.containers.remove(container);
    }

    public synchronized void start() {
        if (!this.running) {
            this.containers.forEach(container -> {
                LOGGER.debug(() -> "Starting: " + String.valueOf(container));
                container.start();
            });
            this.running = true;
        }
    }

    public synchronized void stop() {
        if (this.running) {
            this.containers.forEach(container -> container.stop());
            this.running = false;
        }
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public String toString() {
        return "ContainerGroup [name=" + this.name + ", containers=" + String.valueOf(this.containers) + "]";
    }
}

